<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'keyword' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbmail_keyword_management']);

	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];

	if (count(VBMAIL::$cache['keyword']))
	{
		print_form_header('vbmail', 'keyword');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbmail_keyword_management'], count($headings));
		print_cells_row($headings, 0, 'thead');

		foreach (VBMAIL::$cache['keyword'] as $keywordid => $keyword)
		{
			// Table data
			$cell = array();
			$cell[] = $keyword['title'];
			$cell[] = $keyword['description'];
			$cell[] = ($keyword['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = construct_link_code($vbphrase['edit'], 'vbmail.php?' . $vbulletin->session->vars['sessionurl'] . 'do=keyword&amp;action=modify&amp;keywordid=' . $keywordid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbmail.php?' . $vbulletin->session->vars['sessionurl'] . 'do=keyword&amp;action=delete&amp;keywordid=' . $keywordid);

			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['dbtech_vbmail_add_new_keyword'], false, count($headings));
	}
	else
	{
		print_form_header('vbmail', 'keyword');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbmail_keyword_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbmail_no_keywords'], false, count($headings));
		print_submit_row($vbphrase['dbtech_vbmail_add_new_keyword'], false, count($headings));
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$keywordid = $vbulletin->input->clean_gpc('r', 'keywordid', TYPE_UINT);
	$keyword = ($keywordid ? VBMAIL::$cache['keyword'][$keywordid] : false);

	if (!is_array($keyword))
	{
		// Non-existing keyword
		$keywordid = 0;
	}

	$defaults = array(
		'title' 		=> 'Word',
		'description' 	=> 'A word contained in the mailing list.',
		'active' 		=> 1,
	);

	if ($keywordid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbmail_editing_x_y'], $vbphrase['dbtech_vbmail_keyword'], $keyword['title'])));
		print_form_header('vbmail', 'keyword');
		construct_hidden_code('action', 'update');
		construct_hidden_code('keywordid', $keywordid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbmail_editing_x_y'], $vbphrase['dbtech_vbmail_keyword'], $keyword['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbmail_add_new_keyword']);
		print_form_header('vbmail', 'keyword');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_vbmail_add_new_keyword']);

		$keyword = $defaults;
	}

	print_description_row($vbphrase['dbtech_vbmail_main_settings'], false, 2, 'optiontitle');
	print_input_row($vbphrase['title'], 			'keyword[title]', 			$keyword['title']);
	print_textarea_row($vbphrase['description'],	'keyword[description]',		$keyword['description']);
	print_yes_no_row($vbphrase['active'],			'keyword[active]',			$keyword['active']);
	print_submit_row(($keywordid ? $vbphrase['save'] : $vbphrase['dbtech_vbmail_add_new_keyword']));
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'keywordid' 	=> TYPE_UINT,
		'keyword' 		=> TYPE_ARRAY,
	));

	// init data manager
	$dm =& VBMAIL::initDataManager('Keyword', $vbulletin, ERRTYPE_CP);

	// set existing info if this is an update
	if ($vbulletin->GPC['keywordid'])
	{
		if (!$existing = VBMAIL::$cache['keyword'][$vbulletin->GPC['keywordid']])
		{
			// Couldn't find the keyword
			print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_keyword'], $vbulletin->GPC['keywordid']);
		}

		// Set existing
		$dm->set_existing($existing);

		// Added
		$phrase = $vbphrase['dbtech_vbmail_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbmail_added'];
	}

	// keyword fields
	foreach ($vbulletin->GPC['keyword'] AS $key => $val)
	{
		if (!$vbulletin->GPC['keywordid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}

	// Save! Hopefully.
	$dm->save();

	define('CP_REDIRECT', 'vbmail.php?do=keyword');
	print_stop_message('dbtech_vbmail_x_y', $vbphrase['dbtech_vbmail_keyword'], $phrase);
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'keywordid', TYPE_UINT);

	print_cp_header(construct_phrase($vbphrase['dbtech_vbmail_delete_x'], $vbphrase['dbtech_vbmail_keyword']));
	print_delete_confirmation('dbtech_vbmail_keyword', $vbulletin->GPC['keywordid'], 'vbmail', 'keyword', 'dbtech_vbmail_keyword', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'keywordid' => TYPE_UINT,
		'kill' 		 => TYPE_BOOL
	));

	if (!$existing = VBMAIL::$cache['keyword'][$vbulletin->GPC['keywordid']])
	{
		// Couldn't find the keyword
		print_stop_message('dbtech_vbmail_invalid_x', $vbphrase['dbtech_vbmail_keyword'], $vbulletin->GPC['keywordid']);
	}

	// init data manager
	$dm =& VBMAIL::initDataManager('Keyword', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();

	define('CP_REDIRECT', 'vbmail.php?do=keyword');
	print_stop_message('dbtech_vbmail_x_y', $vbphrase['dbtech_vbmail_keyword'], $vbphrase['dbtech_vbmail_deleted']);
}


print_cp_footer();